//
//  COGlyphRecord.h
//  GSFontTools
//
//  Created by Georg Seifert on 04.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class OTValueRecord;

NSMutableArray *glyphNamesToGlyphRecords(NSArray *glyphList);
NSMutableArray *glyphRecordsToGlyphNames(NSArray *glyphRecords);

@interface COGlyphRecord : NSObject {
	id _glyph;
	NSString *_glyphName;
	NSInteger _xPlacement;
	NSInteger _yPlacement;
	NSInteger _xAdvance;
	NSInteger _yAdvance;
	NSInteger _advanceWidth;
	NSInteger _advanceHeight;
	NSMutableArray *_alternates;
	NSString *_alternatesReference;
	NSArray *_ligatureComponents;
	NSArray *_ligatureComponentsReference;
	NSMutableArray *_substitutionHistory;

	NSDictionary *_attributes;
}
@property (retain, nonatomic) NSString *glyphName;
@property (retain, nonatomic) NSArray *ligatureComponents;
@property (retain, nonatomic) NSMutableArray *alternates;
@property (retain, nonatomic) NSString *alternatesReference;
@property (nonatomic, retain) NSDictionary *attributes;
@property (nonatomic, retain) NSMutableArray *substitutionHistory;

/**
 The difference between the number of original glyphs (always 1) and the number of glyphs with which the original glyph was substituted. The sign indicates the direction of substitution, with negative for many-to-one substitutions and positive for one-to-many substitutions.

 Please note: This is not the number of substitutions as recorded in the substitutionHistory! Therefore, this can be zero if a glyph was substituted with another single glyph, even multiple times.

 Example 1: f and i are replaced with ﬁ (‘liga’ feature), `substitutionDelta` is 1 – 2 = –1.
 Example 2: a is replaced with bcd (‘multi’ feature), `substitutionDelta` is 3 – 1 = +2.
 Example 3: 1 is replaced with ¹ (nominator), then with ₁ (denominator; ‘frac’ feature), `substitutionDelta` is 1 – 1 = ±0 (once for each substitution).
 */
@property (nonatomic, assign) NSInteger substitutionDelta;

@property (nonatomic, assign) NSInteger xPlacement;
@property (nonatomic, assign) NSInteger yPlacement;
@property (nonatomic, assign) NSInteger xAdvance;
@property (nonatomic, assign) NSInteger yAdvance;
@property (nonatomic, assign) NSInteger advanceWidth;
@property (nonatomic, assign) NSInteger advanceHeight;

- (id)initWithGlyphName:(NSString *)glyphName;
- (void)addValues:(OTValueRecord *)aValueRecord;

/**
 Appends the given glyph names to the receiver’s substitution history.
 Also decrements the receiver’s `substitutionIndexOffset` property by the number of glyph names.

 @param GlyphNames An array of glyph names (as NSString objects) to append.
 */
- (void)saveState:(NSArray *)glyphNames;

/**
 Increments the receiver’s `substitutionIndexOffset` property by the number of glyph names.

 @param glyphNames An array of glyph names (as NSString objects) to append.
 */
- (void)saveFutureState:(NSArray *)glyphNames;

- (BOOL)side1IsBreak:(NSDictionary *)reversedCMAP;
- (BOOL)side2IsBreak:(NSDictionary *)reversedCMAP;
@end
